<?php

// include(__DIR__ . '/../../web-panel/functions/database-connection.php');

function get_data($table, $column) {
    global $database_connection;

    $query = "SELECT `$column` FROM `$table` LIMIT 1";
    $result = $database_connection->query($query);

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        return $row[$column];
    }

    return null;
}


function update_data($table, $column, $value) {
    global $database_connection;

    // Evita SQL injection
    $table = mysqli_real_escape_string($database_connection, $table);
    $column = mysqli_real_escape_string($database_connection, $column);
    $value = mysqli_real_escape_string($database_connection, $value);

    // Monta a query
    $query = "UPDATE `$table` SET `$column` = '$value' LIMIT 1";

    // DEBUG opcional — registra a query no log de erros do PHP
    error_log("Query UPDATE: " . $query);

    // Executa e retorna resultado booleano
    return $database_connection->query($query);
}

/**
 * Community Deep Link (via sessão) com modo DEBUG
 * - Push abre: https://SEU_DOMINIO/?screen=community
 * - Se estiver logado ( $_SESSION['usuario']['id'] ), resolve e redireciona para o invite
 * - Se não estiver logado: não faz nada
 * - Debug: acrescente &debug=1 para ver um relatório completo do fluxo
 */

if (!function_exists('connectclub_boot_session')) {
  add_action('init', 'connectclub_boot_session', 1);
  function connectclub_boot_session() {
    if (session_status() === PHP_SESSION_NONE) {
      $is_ssl = is_ssl();
      $params = session_get_cookie_params();
      session_set_cookie_params([
        'lifetime' => 0,
        'path'     => $params['path'] ?: '/',
        'domain'   => $params['domain'] ?: parse_url(home_url(), PHP_URL_HOST),
        'secure'   => $is_ssl,
        'httponly' => true,
        'samesite' => 'Lax',
      ]);
      @session_start();
    }
  }
}

if (!function_exists('connectclub_redirect_community_when_logged')) {
  add_action('template_redirect', 'connectclub_redirect_community_when_logged');
  function connectclub_redirect_community_when_logged() {
    if (!is_front_page()) return;

    $screen = isset($_GET['screen']) ? strtolower(sanitize_text_field($_GET['screen'])) : '';
    if ($screen !== 'community') return;

    $DEBUG = isset($_GET['debug']) && $_GET['debug'] == '1';
    $dbg = [
      'stage'          => 'start',
      'has_session'    => (session_status() === PHP_SESSION_ACTIVE),
      'session_keys'   => array_keys($_SESSION ?? []),
      'session_usuario'=> isset($_SESSION['usuario']) ? $_SESSION['usuario'] : null,
      'uuid_raw'       => null,
      'uuid_mode'      => null, // 'uuid' | 'id' | null
      'shop_query'     => null,
      'shop_id'        => null,
      'groups_query'   => null,
      'groups_row'     => null,
      'wpdb_error'     => null,
      'final_redirect' => null,
      'why'            => [],
    ];

    // 1) Captura ID/UUID da sessão
    $uuidRaw = '';
    if (isset($_SESSION['usuario']['id'])) {
      $uuidRaw = $_SESSION['usuario']['id'];
    }
    $uuidRaw = sanitize_text_field((string)$uuidRaw);
    $dbg['uuid_raw'] = $uuidRaw;

    if ($uuidRaw === '') {
      $dbg['why'][] = 'no_session_id';
      if ($DEBUG) { wp_die('<pre>'.esc_html(print_r($dbg,true)).'</pre>'); }
      return; // não logado -> não faz nada
    }

    // Decide se é UUID (alfanum/hífen/_) ou ID numérico
    $isUuidLike = (bool)preg_match('/^[A-Za-z0-9\-\_]{6,}$/', $uuidRaw);
    $isNumericId = ctype_digit($uuidRaw);

    global $wpdb;

    // 2) Busca loja_mais_frequentada
    if ($isUuidLike && !$isNumericId) {
      $dbg['uuid_mode']  = 'uuid';
      $shop_sql_prepared = $wpdb->prepare(
        "SELECT loja_mais_frequentada FROM customers WHERE cliente_uuid = %s LIMIT 1",
        $uuidRaw
      );
    } else {
      $dbg['uuid_mode']  = 'id';
      $shop_sql_prepared = $wpdb->prepare(
        "SELECT loja_mais_frequentada FROM customers WHERE id = %d LIMIT 1",
        (int)$uuidRaw
      );
    }
    $dbg['shop_query'] = $shop_sql_prepared;
    $shopId = (int)$wpdb->get_var($shop_sql_prepared);
    $dbg['shop_id'] = $shopId;
    if (!empty($wpdb->last_error)) $dbg['wpdb_error'] = $wpdb->last_error;

    if ($shopId <= 0) {
      $dbg['why'][] = 'no_shop_for_user';
      if ($DEBUG) { wp_die('<pre>'.esc_html(print_r($dbg,true)).'</pre>'); }
      return; // sem loja -> não redireciona
    }

    // 3) Busca grupo com vaga
    $groups_sql = "
      SELECT g.invite_link, COALESCE(gr.members,0) AS members
      FROM wpp_groups g
      LEFT JOIN (
        SELECT group_id, COUNT(*) AS members
        FROM wpp_groups_related
        GROUP BY group_id
      ) gr ON gr.group_id = g.id
      WHERE g.shop = %d
        AND g.status = 1
        AND g.invite_link IS NOT NULL
        AND COALESCE(gr.members,0) < 2000
      ORDER BY members ASC
      LIMIT 1
    ";
    $groups_sql_prepared = $wpdb->prepare($groups_sql, $shopId);
    $dbg['groups_query'] = $groups_sql_prepared;

    $row = $wpdb->get_row($groups_sql_prepared, ARRAY_A);
    if (!empty($wpdb->last_error)) $dbg['wpdb_error'] = $wpdb->last_error;
    $dbg['groups_row'] = $row;

    $invite = $row['invite_link'] ?? '';
    if ($invite && filter_var($invite, FILTER_VALIDATE_URL)) {
      $dbg['final_redirect'] = $invite;
      if ($DEBUG) {
        wp_die('<pre>'.esc_html(print_r($dbg,true)).'</pre>'); // veja o invite antes de redirecionar
      }
      nocache_headers();
      wp_redirect($invite);
      exit;
    }

    // sem link/grupo -> não redireciona
    $dbg['why'][] = 'no_group_invite';
    if ($DEBUG) { wp_die('<pre>'.esc_html(print_r($dbg,true)).'</pre>'); }
    return;
  }
}