<article class="modal" id="modalImages">
  
  <div class="container-fluid">
    
    <div class="box">

        <div class="headModal">

            <h3>Alterar Foto</h3>
            <span id="closeModal">
            <i class="fa-solid fa-arrow-left" onclick="$('#modalImages').removeClass('open');"></i>
            </span>

        </div>

        <div class="contentModal">	

            <div class="row form-search-image">
                <label>Digite o nome do produto para pesquisar a imagem</label>
                <input type="text" class="form-control" name="search_nome_produto" value="Alcatra Bovina">
                <input type="hidden" name="search_identificador">
                <input type="hidden" name="search_ean"><!-- ✅ NOVO -->
                <input type="hidden" name="product_id">
            </div>

            <div class="row form-upload-image" style="width: 100%">
                <button id="uploadImageButton" class="btnDefault" style="margin: 0px auto 40px auto;">
                    <i class="fa-solid fa-file-import"></i> Enviar imagem
                </button>
            </div>

            <div class="row" id="resultadosImage"></div>

        </div>

    </div>
    
  </div>

</article>

<script>
    $('#search_imagem').click(function(){
        var search = $(this).attr('data-imagem');
        var identificador = $(this).attr('data-id');
        var ofertaId = $(this).attr('data-oferta');

        // ✅ tenta pegar EAN direto do botão, se você começar a enviar por lá
        var ean = $(this).attr('data-ean') || '';

        // ✅ fallback: pega do bloco do produto pelo data-id (ofertaId)
        if (!ean && ofertaId) {
            ean = $('.blocoOfertaApp[data-id="'+ ofertaId +'"]').attr('data-ean') || '';
        }

        // Preencher os campos
        $('input[name="product_id"]').val(ofertaId);
        $('input[name="search_identificador"]').val(identificador);
        $('input[name="search_nome_produto"]').val(search).change();
        $('input[name="search_ean"]').val(ean); // ✅ salva EAN

        buscarImagensProduto(search); // ✅ não precisa passar ean aqui, ele pega do hidden
    });

    $(document).on('input', 'input[name="search_nome_produto"]', function() {
        buscarImagensProduto($(this).val());
    });

    $(document).on('click', '.resultadoImagem img', function() {
        $('.resultadoImagem img').removeClass('selected');
        $(this).addClass('selected');

        var source = $(this).attr('src');
        var productName = $('input[name="search_nome_produto"]').val();
        var idLoad = $('input[name="search_identificador"]').val();
        var productId = $('input[name="product_id"]').val();

        var elemento = $('.blocoOfertaApp[data-id="'+ productId +'"] .editable-imagem img');

        if (elemento.length > 0) {
            elemento.attr('src', source);
        } else {
            $('[data-id="'+ productId +'"] .editable-imagem').attr('src', source);
        }

        $('#modalProduto img').attr('src', source);
        $('#modalImages').removeClass('open');
        $('#modalProduto').removeClass('open');

        $.ajax({
            type: 'POST',
            url: window.location.origin + "/wp-content/themes/app/mobile-view/server-side/offer-control/server-processing-control-images.php",
            data: {
                'produto' : $(this).val(),
                'action' : 'update',
                'productId' : productId,
                'imagem' : source
            },
        })
        .done(function(response) {

            Swal.fire({
                icon: 'success',
                title: 'Imagem alterada!',
                text: `Você alterou com sucesso a imagem de `+productName+'.',
                timer: 2000,
                showConfirmButton: false
            });

        })
        .fail(function() {
            alert("Erro ao atualizar imagem");
        });
    }); 
 
    function buscarImagensProduto(produto) {
        $('#resultadosImage').html(`
            <div class="skeleton-container">
                <div class="skeleton-item"></div>
                <div class="skeleton-item"></div>
                <div class="skeleton-item"></div>
                <div class="skeleton-item"></div>
                <div class="skeleton-item"></div>
                <div class="skeleton-item"></div>
                <div class="skeleton-item"></div>
                <div class="skeleton-item"></div>
                <div class="skeleton-item"></div>
                <div class="skeleton-item"></div>
                <div class="skeleton-item"></div>
                <div class="skeleton-item"></div>
            </div>
        `);

        // ✅ pega EAN do hidden SEMPRE
        var ean = $('input[name="search_ean"]').val() || '';

        $.ajax({
            type: 'POST',
            url: window.location.origin + "/wp-content/themes/app/mobile-view/server-side/offer-control/server-processing-control-images.php",
            data: {
                'produto': produto,
                'ean': ean,          // ✅ ENVIA SEMPRE
                'action': 'search'
            },
        })
        .done(function(response) {
            $('#resultadosImage').html(response);
        })
        .fail(function() {
            alert("Erro ao carregar imagem");
        });
    }

    var mediaUploader;

    $('#uploadImageButton').click(function(e) {
        e.preventDefault();

        var productId = $('input[name="product_id"]').val();
        var productName = $('input[name="search_nome_produto"]').val();

        if (mediaUploader) {
            mediaUploader.open();
            return;
        }

        mediaUploader = wp.media({
            title: 'Selecionar ou Fazer Upload de Imagem',
            button: { text: 'Usar esta Imagem' },
            multiple: false,
            library: { type: 'image' },
        });

        mediaUploader.on('select', function() {
            var attachment = mediaUploader.state().get('selection').first().toJSON();
            var postId = $('input[name="product_id"]').val();

            $.ajax({
                url: window.location.origin + "/wp-content/themes/app/mobile-view/server-side/offer-control/server-processing-control-images.php",
                type: "POST",
                data: {
                    action: 'upload_thumbnail',
                    productId: postId,
                    attachmentId: attachment.id
                },
                success: function(response) {

                    $('.blocoOfertaApp[data-id="'+ postId +'"] img').attr('src', attachment.url);

                    if (response == 200) {
                        $('#modalImages').removeClass('open');
                        Swal.fire({
                            icon: 'success',
                            title: 'Imagem alterada!',
                            text: `Você alterou com sucesso a imagem de `+productName+'.',
                            timer: 2000,
                            showConfirmButton: false
                        });
                    } else {
                        alert('Erro ao atualizar a imagem.');
                    }
                },
                error: function() {
                    alert('Erro no upload da imagem.');
                }
            });
        });

        mediaUploader.open();
    });
</script>
