<?php
	if (isset($_SESSION['usuario']) && !empty(get_info('loja_mais_frequentada', $_SESSION['usuario']['id'])) && get_info('data_nascimento', $_SESSION['usuario']['id']) != "0000-00-00"):
?>


		<article class="modal open" id="recoveryInfo">
			
			<div class="container-fluid">
				
				<div class="box">
					<h3>Diga pra nós</h3>
					<form method="POST" class="row" id="atualizarInfoRecovery">
						<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
							<label for="loja">Qual loja você mais frequenta?</label>
							<select name="loja" id="loja" required>
								<?php
									$taxonomy = 'loja';
									$terms = get_terms([
									    'taxonomy' => $taxonomy,
									    'hide_empty' => false,
									]);
									foreach ($terms as $term) {
								?>
								<option value="<?= $term->term_id; ?>"><?= $term->name; ?></option>
								<?php } ?>
							</select>
						</div>
						<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
							<label for="genero">Qual seu gênero?</label>
							<select name="genero" id="genero" required>
								<option value="Masculino">Masculino</option>
								<option value="Feminino">Feminino</option>
							</select>
						</div>
						<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
							<label for="nascimento">Quando você nasceu?</label>
							<input type="text" id="nascimento" name="nascimento" placeholder="01/01/2000" class="birthdate" onchange="validateBirthdate()" required>
							<br>
						</div>
						<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
							<label for="celular">Seu número de celular?</label>
							<input type="text" name="celular" value="<?= get_info('celular', $_SESSION['usuario']['id']) ?>" placeholder="(00) 00000-0000" minlength="15" class="phone_with_ddd" required="" maxlength="15">
							<br>
						</div>
						<input type="text" name="id" value="<?= $_SESSION['usuario']['id']; ?>" hidden>
						<button type="submit" class="btnDefault">Pronto</button>
					</form>
				</div>
				
			</div>

		</article>

		<script type="text/javascript">
			document.getElementById('atualizarInfoRecovery').addEventListener('submit', function(e) {
			  e.preventDefault();
			  var formData = new FormData(this);
				$.ajax({
				    type: 'POST',
				    url: '<?php echo get_template_directory_uri(); ?>/mobile-view/server-side/access-control/logged-in/server-processing-change-recovery-info.php',
				    data: formData,
				    processData: false,
				    contentType: false,
				    success: function (response) {
						var response = JSON.parse(response);
				        if(response.success) {
				        	$('#recoveryInfo').removeClass('open');
				        }
				    },
				    error: function () {
				        alert('Houve um erro ao atualizar os dados. Por favor, tente novamente.');
				    }
				});
			});
		</script>

<?php
	endif;
?>