<?php

    session_start();
    require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';


    if (!isset($_POST['user'], $_POST['nascimento'], $_POST['genero'])) {
        die(json_encode(array('success' => false, 'message' => 'Dados incompletos.')));
    }

    $usuario = $_POST['user'];
    $nascimento = $_POST['nascimento'];
    $genero = $_POST['genero'];

    // Converte a data de nascimento de DD/MM/YYYY para YYYY-MM-DD
    list($dia, $mes, $ano) = explode('/', $nascimento);
    if (!checkdate($mes, $dia, $ano)) {
        die(json_encode(array('success' => false, 'message' => 'Data de nascimento inválida.')));
    }
    $nascimentoFormatado = "$ano-$mes-$dia";

    // Valida o gênero
    $generoPermitido = ['Masculino', 'Feminino', 'N/F'];
    if (!in_array($genero, $generoPermitido)) {
        die(json_encode(array('success' => false, 'message' => 'Gênero inválido.')));
    }

    // Prepara a consulta para evitar injeção SQL
    $stmt = $database_connection->prepare("UPDATE customers SET data_nascimento = ?, genero = ? WHERE cliente_uuid = ?");
    $stmt->bind_param('sss', $nascimentoFormatado, $genero, $usuario);

    if ($stmt->execute()) {
        // Atualização bem-sucedida
        echo json_encode(array('success' => true));
    } else {
        // Erro ao atualizar
        echo json_encode(array('success' => false, 'message' => 'Erro ao atualizar os dados no banco de dados.'));
    }

    $stmt->close();
    $database_connection->close();

?>
