<?php

session_start();
require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';

header('Content-Type: application/json');

$response = ['showModal' => false];

if (!isset($_SESSION['usuario']['id'])) {
    echo json_encode($response);
    exit;
}

$customerId = $database_connection->real_escape_string($_SESSION['usuario']['id']);

// verifica se já está relacionado a grupo ativo
$queryCheck = "
    SELECT g.invite_link
    FROM wpp_groups_related gr
    INNER JOIN wpp_groups g ON g.id = gr.group_id
    WHERE gr.customer_id = '{$customerId}'
      AND gr.status = 1
      AND g.status = 1
    LIMIT 1
";
$resCheck = $database_connection->query($queryCheck);

if ($resCheck && $resCheck->num_rows > 0) {
    echo json_encode($response); // já está em grupo ativo
    exit;
}

// pega a loja mais frequentada
$queryLoja = "
    SELECT loja_mais_frequentada 
    FROM customers 
    WHERE cliente_uuid = '{$customerId}'
    LIMIT 1
";
$resLoja = $database_connection->query($queryLoja);
$lojaId = null;

if ($resLoja && $resLoja->num_rows > 0) {
    $lojaId = $resLoja->fetch_assoc()['loja_mais_frequentada'];
}

// se tem loja definida, procurar grupo ativo da loja com menos de 2000 membros
if ($lojaId) {
    $queryGrupo = "
        SELECT g.id, g.invite_link, COUNT(gr.id) as total_membros
        FROM wpp_groups g
        LEFT JOIN wpp_groups_related gr ON g.id = gr.group_id AND gr.status = 1
        WHERE g.shop = '{$lojaId}'
          AND g.status = 1
        GROUP BY g.id
        HAVING total_membros < 2000
        ORDER BY total_membros ASC
        LIMIT 1
    ";
    $resGrupo = $database_connection->query($queryGrupo);

    if ($resGrupo && $resGrupo->num_rows > 0) {
        $grupo = $resGrupo->fetch_assoc();
        $response = [
            'showModal' => true,
            'invite_link' => $grupo['invite_link']
        ];
    }
}

echo json_encode($response);