<?php 

require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-functions/api/control-api-market-request.php';

$retorno = 0;
$opcao = $_POST['radio'];
$cpf = $_POST['cpf'];
$email = $_POST['email'];
$celular = $_POST['celular'];

$valor_opcao = ($opcao == 'email') ? $email : $celular;

$sql = "SELECT * FROM customers WHERE cpf = ? AND $opcao = ?";
$stmt = $database_connection->prepare($sql);
$stmt->bind_param("ss", $cpf, $valor_opcao);
$stmt->execute();
$resultado = $stmt->get_result();
$codigo_verificacao = rand(100000, 999999);

if($resultado->num_rows > 0) {
    if ($opcao == 'email') {

        $subject = "Código de Verificação";
        $body = "<p>Seu código de verificação para redefinir a senha é:</p><p><strong>$codigo_verificacao</strong></p><p>O código é válido por 15 minutos.</p>";
        $retorno = send_email_global($email, $subject, $body);
        if($retorno == true){
            session_start();
            $_SESSION['codigo_verificacao'] = $codigo_verificacao;
            $_SESSION['verificacao_expira'] = time() + (15 * 60); // 15 minutos
            $_SESSION['cpf_verificacao'] = $cpf;

            $retorno = json_encode([
                "success" => true,
                "message" => "Um código de verificação foi enviado em seu " . $opcao . ".",
                "cpf" => $cpf
            ]);

        }else{
            $retorno = json_encode(["success" => false, "message" => "Ops! No momento não conseguimos redefinir senha através do ".$opcao." informado."]);
        }

    } elseif ($opcao == 'celular') {

        while ($row = $resultado->fetch_assoc()) {

            $instancia_id = get_field('instancia_id_notificacao', 'options');
            $instancia_token = get_field('token_notificacao', 'options');
            $instancia_dominio = get_field('url_instancia_notificacao', 'options');;

            if(empty($instancia_id) || empty($instancia_token)){
                $retorno = json_encode(["success" => false, "message" => "Ops! No momento não conseguimos redefinir senha através do ".$opcao." informado."]);
            }else{
                $retorno = enviarCodigoCelular($celular, $instancia_id, $instancia_token, $instancia_dominio, $codigo_verificacao);
                if($retorno == true){
                   session_start();
                    $_SESSION['codigo_verificacao'] = $codigo_verificacao;
                    $_SESSION['verificacao_expira'] = time() + (15 * 60); // 15 minutos
                    $_SESSION['cpf_verificacao'] = $cpf;

                    $retorno = json_encode([
                        "success" => true,
                        "message" => "Um código de verificação foi enviado em seu " . $opcao . "."
                    ]);
                }else{
                    $retorno = json_encode(["success" => false, "message" => "Ops! No momento não conseguimos redefinir senha através do ".$opcao." informado."]);
                }
            }

        }
        
    }

}else{

    $retorno = json_encode(["success" => false, "message" => "Nenhum cadastro foi encontrado com o CPF e ".$opcao." informado."]);

}

echo $retorno;
exit;

function enviarCodigoCelular($celular, $instancia_id, $instancia_token, $instancia_dominio, $codigo_verificacao) {

    $celular = preg_replace('/\D/', '', $celular);
	$instancia_url = get_field('url_instancia_notificacao', 'options');

    $params = [
        "user" => "55".$celular,
        "sender" => $instancia_id,
        "token" => $instancia_token,
        "message" => "Seu código de verificação para redefinição de senha é: *$codigo_verificacao*. Ele é válido por 15 minutos."
    ];

    $domainSendMessage = explode(':', $instancia_dominio);
    $protocolo = $domainSendMessage[0];

    $domainSendMessage = explode('//', $domainSendMessage[1]);

    $porta = explode('_port_', $instancia_id);
    $porta = $porta[1];

    $url = $instancia_url.":".$porta."/send-message";

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode($params),
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'Connection: keep-alive',
            'Cache-Control: no-cache',
            'Accept: */*',
            'User-Agent: SuaApp/1.0',
        ],
    ]);

    $response = curl_exec($curl);
    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE); // Obtém o código de status HTTP
    curl_close($curl);

    return $response;
    
}

?>