<?php
session_start();
require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';

$cpf      = $_POST['cpf']      ?? '';
$password = md5($_POST['password'] ?? '');

if (!$cpf || !$password) {
    echo 0;
    exit;
}

global $database_connection;

$query = "SELECT * FROM customers WHERE cpf = ? AND senha = ? LIMIT 1";
$stmt  = $database_connection->prepare($query);
$stmt->bind_param('ss', $cpf, $password);
$stmt->execute();
$result = $stmt->get_result();

if (!$result || $result->num_rows === 0) {
    echo 0; // não encontrado
    exit;
}

$row    = $result->fetch_assoc();
$status = $row['status'] ?? '';

if ($status === 'publish') {
    // Login normal
    $userID = $row['cliente_uuid'];

    $_SESSION['usuario'] = ['id' => $userID];

    // Mantém lógica PDV
    if ((int)$row['pdv'] === 0 && function_exists('get_status_api') && get_status_api(5) == 1 && function_exists('save_user_api')) {
        $return = save_user_api(
            $row['nome'],
            $row['cpf'],
            $row['rua'],
            $row['numero'],
            $row['bairro'],
            $row['cidade'],
            $row['estado'],
            $row['cep'],
            $row['celular'],
            $row['email'],
            $row['genero']
        );

        if ($return == 1) {
            $upd = $database_connection->prepare("UPDATE customers SET pdv = '1' WHERE cliente_uuid = ?");
            $upd->bind_param('s', $userID);
            $upd->execute();
        }
    }

    echo 1;
    exit;
}

if ($status === 'draft') {
    // Está desativado
    $email = trim((string)($row['email'] ?? ''));

    if ($email === '') {
        // Sem e-mail: não tem como mandar código
        // 3 = "não foi possível reativar a conta por falta de email"
        echo 3;
        exit;
    }

    // Tem e-mail: front pergunta se quer reativar + fluxo de código
    echo 2;
    exit;
}

// Qualquer outro status trata como falha
echo 0;
exit;
