<?php
session_start();
require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';

header('Content-Type: application/json; charset=utf-8');

$cpf      = $_POST['cpf']      ?? '';
$password = md5($_POST['password'] ?? '');

if (!$cpf || !$password) {
    echo json_encode([
        'success' => false,
        'message' => 'Dados inválidos.'
    ]);
    exit;
}

global $database_connection;

$sql = "SELECT id, cliente_uuid, email, status 
        FROM customers 
        WHERE cpf = ? AND senha = ? 
        LIMIT 1";
$stmt = $database_connection->prepare($sql);
$stmt->bind_param("ss", $cpf, $password);
$stmt->execute();
$result = $stmt->get_result();
$row    = $result ? $result->fetch_assoc() : null;

if (!$row || $row['status'] !== 'draft') {
    echo json_encode([
        'success' => false,
        'message' => 'Cadastro não encontrado para reativação.'
    ]);
    exit;
}

$email = trim((string)$row['email']);
if ($email === '') {
    echo json_encode([
        'success' => false,
        'code'    => 'no_email',
        'message' => 'Não foi possível reativar a conta por falta de e-mail. Contate o supermercado.'
    ]);
    exit;
}

// Gera código aleatório
$codigo_verificacao = random_int(100000, 999999);

// Guarda na sessão (15 minutos)
$_SESSION['reactivate_code']    = $codigo_verificacao;
$_SESSION['reactivate_expires'] = time() + (15 * 60);
$_SESSION['reactivate_cpf']     = $cpf;
$_SESSION['reactivate_userid']  = $row['cliente_uuid'];

// Monta e-mail (reaproveitando padrão do reset)
$subject = "Código de verificação para reativar cadastro";
$body    = "
<p>Você solicitou a reativação do seu cadastro.</p>
<p>Seu código de verificação é:</p>
<p><strong>{$codigo_verificacao}</strong></p>
<p>O código é válido por 15 minutos.</p>
<p>Se você não solicitou esta ação, apenas ignore esta mensagem.</p>
";

// Se você já usa send_email_global no reset, reaproveita aqui:
if (function_exists('send_email_global')) {
    $sent = send_email_global($email, $subject, $body);
} else {
    // fallback com wp_mail, se precisar
    $headers = ['Content-Type: text/html; charset=UTF-8'];
    $sent = wp_mail($email, $subject, $body, $headers);
}

if (!$sent) {
    echo json_encode([
        'success' => false,
        'message' => 'Não foi possível enviar o código de verificação. Tente novamente.'
    ]);
    exit;
}

// Mascarar e-mail para exibir no front
list($userPart, $domainPart) = explode('@', $email, 2);
$maskedUser  = substr($userPart, 0, 2) . str_repeat('*', max(1, strlen($userPart) - 2));
$email_masked = $maskedUser . '@' . $domainPart;

echo json_encode([
    'success'      => true,
    'message'      => 'Enviamos um código de verificação para o seu e-mail.',
    'email_masked' => $email_masked,
]);
exit;
