<?php
session_start();
require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';

header('Content-Type: application/json; charset=utf-8');

$cpf      = $_POST['cpf']      ?? '';
$password = md5($_POST['password'] ?? '');
$code     = $_POST['code']     ?? '';

if (!$cpf || !$password || !$code) {
    echo json_encode(['success' => false, 'message' => 'Dados inválidos.']);
    exit;
}

// Confere se existe código ativo na sessão
if (
    empty($_SESSION['reactivate_code']) ||
    empty($_SESSION['reactivate_expires']) ||
    empty($_SESSION['reactivate_cpf'])
) {
    echo json_encode([
        'success' => false,
        'message' => 'Solicitação de reativação inválida ou expirada.'
    ]);
    exit;
}

// Expirado?
if (time() > $_SESSION['reactivate_expires']) {
    unset($_SESSION['reactivate_code'], $_SESSION['reactivate_expires'], $_SESSION['reactivate_cpf'], $_SESSION['reactivate_userid']);
    echo json_encode([
        'success' => false,
        'message' => 'Código expirado. Solicite um novo.'
    ]);
    exit;
}

// Confere CPF e código
if (
    $cpf !== $_SESSION['reactivate_cpf'] ||
    (string)$code !== (string)$_SESSION['reactivate_code']
) {
    echo json_encode([
        'success' => false,
        'message' => 'Código de verificação inválido.'
    ]);
    exit;
}

global $database_connection;

// Reativa apenas se continuar em draft com esses dados
$upd = $database_connection->prepare(
    "UPDATE customers 
     SET status = 'publish'
     WHERE cpf = ? AND senha = ? AND status = 'draft'
     LIMIT 1"
);
$upd->bind_param('ss', $cpf, $password);
$upd->execute();

if ($upd->affected_rows <= 0) {
    echo json_encode([
        'success' => false,
        'message' => 'Não foi possível reativar a conta.'
    ]);
    exit;
}

// Descobre ID para logar
$userID = $_SESSION['reactivate_userid'] ?? null;

if (!$userID) {
    $q = $database_connection->prepare("SELECT cliente_uuid FROM customers WHERE cpf = ? LIMIT 1");
    $q->bind_param('s', $cpf);
    $q->execute();
    $r = $q->get_result()->fetch_assoc();
    $userID = $r['cliente_uuid'] ?? null;
}

// Loga usuário
if ($userID) {
    $_SESSION['usuario'] = ['id' => $userID];
}

// Limpa sessão de reativação
unset($_SESSION['reactivate_code'], $_SESSION['reactivate_expires'], $_SESSION['reactivate_cpf'], $_SESSION['reactivate_userid']);

echo json_encode([
    'success' => true,
    'message' => 'Cadastro reativado com sucesso!'
]);
exit;
