<?php

require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';

global $wpdb, $database_connection; // Garante que a conexão com o BD está disponível

$cpf = $_POST['cpf'] ?? ''; 
$novaSenha = $_POST['senha'] ?? '';

if (empty($cpf) || empty($novaSenha)) {
    echo json_encode(["success" => false, "message" => "CPF e senha são obrigatórios."]);
    exit;
}

// Função para atualizar a senha
function AtualizarSenha($database_connection, $cpf, $novaSenha) {
    if (strlen($novaSenha) < 6) {
        echo json_encode(["success" => false, "message" => "A senha deve ter pelo menos 6 caracteres."]);
        exit;
    }

    // Hash da nova senha
    $new_password_hashed = md5($novaSenha);

    // Corrigindo a preparação da query
    $query = "UPDATE customers SET senha = ? WHERE cpf = ?";
    $stmt = $database_connection->prepare($query);

    if (!$stmt) {
        echo json_encode(["success" => false, "message" => "Erro ao preparar a query: " . $database_connection->error]);
        exit;
    }

    $stmt->bind_param("ss", $new_password_hashed, $cpf);

    if ($stmt->execute()) {
        echo json_encode(["success" => true, "message" => "Senha alterada com sucesso!"]);
    } else {
        echo json_encode(["success" => false, "message" => "Erro ao atualizar a senha: " . $stmt->error]);
    }

    $stmt->close();
    exit;
}

// Chama a função para atualizar a senha
AtualizarSenha($database_connection, $cpf, $novaSenha);

?>
