<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';
include get_template_directory() . '/web-panel/functions/database-connection.php';

header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
// Verifica se os dados essenciais foram recebidos
if (!$data) {
    echo json_encode(['success' => false, 'message' => 'Dados incompletos.']);
    exit;
}

$action = $data['action'] ?? null;
$numPedido = $data['numeroPedido'] ?? null;
$cnpj = $data['cnpj'] ?? null;
$loja = $data['loja'] ?? null;

$clienteArray = $data['cliente'] ?? []; // mantém como array para acessar chaves
// $clienteUUID = $clienteArray['clienteUUID'] ?? null;
$cliente = json_encode($clienteArray, JSON_UNESCAPED_UNICODE);

$valorTotalLocal = (float)$data['valorTotal'] ?? 0.0;           
$valorProdutos   = isset($data['valorProdutos'])
                   ? (float)$data['valorProdutos']     
                   : 0.0;

$frete = (float)($data['endereco']['frete'] ?? 0);

$observacao = $data['observacao'] ?? null;
// $produtoArray = $data['produtos'] ?? [];
$produtosJson = (json_encode($data['produtos'], JSON_UNESCAPED_UNICODE) ?? null);
$dataAtual = date('Y-m-d H:i:s') ?? null;
$status = 0; 
$tipo = $data['tipo'] ?? 1;
$meioPagamento = $data['meioPagamento'] ?? null;
$endereco = $data['endereco'] ?? null;
$enderecoJson = json_encode($endereco, JSON_UNESCAPED_UNICODE);

$tempoPrevisto = get_data('ecommerce_config', 'tempo_previsto'); 
$ativo = get_data('ecommerce_config', 'ativo');
$delivery = get_data('ecommerce_config', 'delivery_ativo');
$valorMinimo = get_data('ecommerce_config', 'valor_minimo_compra');
$horarioDeFuncionamento = json_decode(get_data('ecommerce_config', 'horario_de_funcionamento'), true);


if ($action == 'create') {

    // Normaliza produtos vindos do front
    if (is_array($data['produtos'])) {
        $produtosArray = $data['produtos'];
    } else {
        $produtosArray = json_decode($data['produtos'], true) ?: [];
    }
    

    // Flag: tem pelo menos 1 item de campanha?
    $temSmart = false;
    foreach ($produtosArray as $p) {
        if ((int)($p['smart_campaign'] ?? 0) > 0) { $temSmart = true; break; }
    }

    // ✅ Só aplica as travas se NÃO for campanha
    if (!$temSmart) {
        if ($ativo == 2 || $ativo == 0) {
            echo json_encode(['success' => false, 'message' => 'E-commerce está pausando no momento 😓.']);
            exit;
        } elseif ($ativo == 3) {
            echo json_encode(['success' => false, 'message' => 'E-commerce está fechado no momento 😓.']);
            exit;
        } elseif ($valorMinimo > $valorTotalLocal) {
            echo json_encode(['success' => false, 'message' => 'O valor minimo para poder realizar a compra é de R$ ' . $valorMinimo . '.']);
            exit;
        }

        if ($tipo == 2) { // delivery
            if ($delivery == 2 || $delivery == 0) {
                echo json_encode(['success' => false, 'message' => 'Delivery está pausando no momento 😓.']);
                exit;
            } elseif ($delivery == 3) {
                echo json_encode(['success' => false, 'message' => 'Delivery está fechado no momento 😓.']);
                exit;
            }
        }
    }

    $clienteUUID = $data['cliente']['clienteUUID'] ?? null;
    $produtosArray = $data['produtos'] ?? [];

    foreach ($produtosArray as $produto) {
        $codigoProduto = $produto['codigoProduto'];
        $quantidadeAtual = intval($produto['quantidade'] ?? 0);
        $smart_id = intval($produto['smart_campaign'] ?? 0);

        if ($smart_id > 0) {
            // Busca limite do produto na campanha
            $sql_smart = "SELECT conteudo, titulo FROM smart_campaign WHERE id = ?";
            $stmt_smart = $database_connection->prepare($sql_smart);
            if (!$stmt_smart) {
                echo json_encode(['success' => false, 'message' => 'Erro ao verificar campanha: ' . $database_connection->error]);
                exit;
            }
            $stmt_smart->bind_param("i", $smart_id);
            $stmt_smart->execute();
            $res_smart = $stmt_smart->get_result();

            if ($row_smart = $res_smart->fetch_assoc()) {
                $conteudo_smart = json_decode($row_smart['conteudo'], true);
                $titulo_campanha = $row_smart['titulo'];

                $limiteProduto = 0;
                foreach ($conteudo_smart as $item) {
                    if ($item['codigo'] == $codigoProduto) {
                        $limiteProduto = intval($item['limite']);
                        break;
                    }
                }

                if ($limiteProduto != 999 && $limiteProduto > 0) {
                    // Busca todos os pedidos anteriores do cliente
                    $sql_total = "SELECT cliente, produtos FROM ecommerce_pedidos";
                    $res_total = $database_connection->query($sql_total);

                    $total_comprado = 0;
                    while ($row_total = $res_total->fetch_assoc()) {
                        $clienteData = json_decode($row_total['cliente'], true);
                        $produtosAntigos = json_decode($row_total['produtos'], true);

                        if (isset($clienteData['clienteUUID']) && $clienteData['clienteUUID'] == $clienteUUID) {
                            foreach ($produtosAntigos as $p) {
                                $smart_prod = intval($p['smart_campaign'] ?? 0);
                                if ($p['codigoProduto'] == $codigoProduto && $smart_prod == $smart_id) {
                                    $total_comprado += intval($p['quantidade']);
                                }
                            }
                        }
                    }

                    if (($total_comprado + $quantidadeAtual) > $limiteProduto) {
                        echo json_encode([
                            'success' => false,
                            'message' => "Você já atingiu o limite de $limiteProduto unidades do produto $codigoProduto na campanha '$titulo_campanha'."
                        ]);
                        exit;
                    }
                }
            }
        }
    }

    // monta $clienteJson (array) e $telefone
    $sqlCliente = "SELECT * FROM customers WHERE cliente_uuid = '$clienteUUID' LIMIT 1";
    $resultCliente = $database_connection->query($sqlCliente);
    if ($resultCliente && $resultCliente->num_rows > 0) {
        $rowCliente = $resultCliente->fetch_assoc();

        // já tem $rowCliente do SELECT em customers e $endereco (do front)
        $clienteJson = [
            'clienteUUID' => $rowCliente['cliente_uuid'] ?? '',
            'nome'        => $rowCliente['nome'] ?? '',
            'cpf'         => $rowCliente['cpf'] ?? '',         
            'celular'     => $rowCliente['celular'] ?? '',
            'rua'         => $rowCliente['rua'] ?? '',
            'numero'      => $rowCliente['numero'] ?? '',
            'complemento' => $rowCliente['complemento'] ?? '',
            'bairro'      => $rowCliente['bairro'] ?? '',
            'cidade'      => $rowCliente['cidade'] ?? '',
            'estado'      => $rowCliente['estado'] ?? '',
            'cep'         => $rowCliente['cep'] ?? '',
            'email'       => $rowCliente['email'] ?? '',
            'genero'      => $rowCliente['genero'] ?? '',
        ];

        $telefone = $rowCliente['celular'] ?? null;
    }

    if (!$telefone) {
        echo json_encode(['success' => false, 'message' => 'É necessário informar um telefone para realizar o pedido.']);
        exit;
    }

    // monta objeto cliente final p/ o ERP unindo dados do cliente + endereço do pedido
    $clienteERP = montar_cliente_erp(
        [
            'nome'     => $clienteJson['nome'],
            'cnpjCpf'  => $clienteJson['cpf'],        
            'telefone' => $clienteJson['celular'],
            'rua'      => $clienteJson['rua'],
            'numero'   => $clienteJson['numero'],
            'complemento'=> $clienteJson['complemento'],
            'bairro'   => $clienteJson['bairro'],
            'cidade'   => $clienteJson['cidade'],
            'estado'   => $clienteJson['estado'],
            'cep'      => $clienteJson['cep'],
            'email'    => $clienteJson['email'],
            'genero'   => $clienteJson['genero'],
        ],
        $endereco ?? [] // prioridade para o endereço de entrega informado no checkout
    );


    $numPedidoApi = (int)($data['numeroPedido'] ?? time()); 
    $pedidoApi    = $numPedidoApi;

    // Campos comuns
    $cnpj         = (string)($data['cnpj'] ?? '');
    $valorTotal   = (float)$data['valorTotal'] ?? 0.0;
    $observacao   = (string)$data['observacao'] ?? '';
    $enderecoJson = json_encode(($data['endereco'] ?? null), JSON_UNESCAPED_UNICODE) ?? '';
    $clienteStr   = json_encode($clienteJson, JSON_UNESCAPED_UNICODE) ?? '';
    $dataAtual    = date('Y-m-d H:i:s') ?? '';
    $status       = 5;
    $tipo         = (int)($data['tipo'] ?? 1) ?? 1;
    $meioPagamento= $data['meioPagamento'] ?? null;


    if (is_array($data['produtos'])) {
        $produtosArr = $data['produtos'];
    } else {
        $produtosArr = json_decode($data['produtos'], true) ?: [];
    }

    $produtosForApi = array_map(function($p){
        return [
            'codigoProduto' => (int)($p['codigoProduto'] ?? $p['codigo'] ?? 0), 
            'quantidade'    => (int)($p['quantidade'] ?? 0),              
            'valorTotal'    => (float)($p['valorTotal'] ?? ($p['precoOferta'] ?? $p['preco_oferta'] ?? 0) * ($p['quantidade'] ?? 0)),
            'observacao'    => (string)($p['observacao'] ?? $p['nome'] ?? ''),
            'percDesconto'  => isset($p['percDesconto'])  ? (float)$p['percDesconto']  : 0.0,
            'valorDesconto' => isset($p['valorDesconto']) ? (float)$p['valorDesconto'] : 0.0,
        ];
    }, $produtosArr);

    // chama a API usando o array pronto (não string json)
    $apiResp = pedidos_ecommerce(
        $numPedidoApi,
        $pedidoApi,
        $cnpj,
        $clienteERP,
        $valorProdutos,
        $observacao,
        $produtosForApi   
    );

    if (!$apiResp['ok']) {
        echo json_encode([
            'success' => false,
            'message' => 'Falha ao registrar pedido tente mais tarde ou contate o suporte.',
            'status'  => $apiResp['status'],
            'retorno' => $apiResp['raw'],
        ]);
        exit;
    }

    // 3) Pega o protocolo (STRING) e usa como numeroPedido no SEU banco
    $numPedidoDb = (string)($apiResp['json']['objeto']['protocolo'] ?? $numPedidoApi);

    // 4) Insere no banco com o protocolo como numeroPedido (ideal: coluna VARCHAR)
    $senha      = $data['senha'] ?? null;
    $senha_hash = md5($senha);

    $stmt = $database_connection->prepare("
        INSERT INTO ecommerce_pedidos (
            numeroPedido, cnpj, loja, cliente, valorTotal,
            observacao, meio_de_pagamento, produtos, `data`, status,
            meio_de_entrega, local_entrega, senha_entrega
        )
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    if (!$stmt) {
        echo json_encode(['success' => false, 'message' => 'Erro na preparação da query: ' . $database_connection->error]);
        exit;
    }

    $stmt->bind_param(
        "ssssdsissiiss",
        $numPedidoDb,     
        $cnpj,
        $loja,
        $clienteStr,
        $valorTotalLocal,
        $observacao,
        $meioPagamento,
        $produtosJson,
        $dataAtual,
        $status,
        $tipo,
        $enderecoJson,
        $senha_hash
    );

    if ($stmt->execute()) {
        $novoId = $database_connection->insert_id;
        
        echo json_encode([
            'success'      => true,
            'numeroPedido' => $numPedidoDb,
            'ids'           => [$novoId],       
            'erp'          => $apiResp['json']
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Erro ao inserir: ' . $stmt->error]);
    }

    $stmt->close();
    $database_connection->close();

}

elseif ($action == 'get_cart') {
    $id = $data['id'] ?? null;
    $senha = $data['senha'] ?? null;
    $html = '';

    $sql = "SELECT * FROM ecommerce_pedidos WHERE cliente->'$.clienteUUID' = '$id' ORDER BY data DESC";
    $result = $database_connection->query($sql);

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {


            $meioEnrega = $row['meio_de_entrega'];
            $labelMeioRetirada = '';

            if($meioEnrega == 2) {
                $labelMeioRetirada = 'Saiu para entrega';
            }
            else {
                $labelMeioRetirada = 'Pronto para buscar';
            }


            $produtos = json_decode($row['produtos'], true);
            switch ($row['status']) {
                case 0:
                    $statusLabel = 'Pendente';
                    $statusClass = 'text-primary'; 
                    break;
                case 1:
                    $statusLabel = 'Em Andamento';
                    $statusClass = 'text-orange'; 
                    break;
                case 2:
                    $statusLabel = $labelMeioRetirada;
                    $statusClass = 'text-warning'; 
                    break;
                case 3:
                    $statusLabel = 'Finalizado';
                    $statusClass = 'text-success';
                    break;
                case 4:
                    $statusLabel = 'Cancelado';
                    $statusClass = 'text-danger'; 
                    break;
                default:
                    $statusLabel = 'Analise';
                    $statusClass = 'text-muted';
            }

            $tipo = $row['meio_de_entrega'];

            if($tipo == 1) {
                $icon = '🏬';
            }
            else {
                $icon = '🛵';
            }

            $dataFormatada = date('d/m/Y H:i:s', strtotime($row['data']));

            $localEntrega = json_decode($row['local_entrega'], true);

            // Monta endereço completo
            $endereco = [];
            if (!empty($localEntrega['rua'])) $endereco[] = $localEntrega['rua'];
            if (!empty($localEntrega['numero'])) $endereco[] = $localEntrega['numero'];
            if (!empty($localEntrega['bairro'])) $endereco[] = $localEntrega['bairro'];
            if (!empty($localEntrega['cidade'])) $endereco[] = $localEntrega['cidade'];
            if (!empty($localEntrega['estado'])) $endereco[] = $localEntrega['estado'];
            if (!empty($localEntrega['cep'])) $endereco[] = $localEntrega['cep'];
            if (!empty($localEntrega['complemento'])) $endereco[] = "Observação: {$localEntrega['complemento']}";
            $localizacao = implode(', ', $endereco);
            
            // $ligarModal = "$('#detalhesModal').addClass('open');";
            
            $ligarModal = "";
            // Monta os produtos
            $produtosHtml = '';
            if (is_array($produtos) && count($produtos) > 0) {
                $primeiroProduto = $produtos[0];
                $quantidadeExtras = count($produtos) - 1;

                $primeiroCodigo = $primeiroProduto['codigoProduto'];
                $post_id = $wpdb->get_var($wpdb->prepare("
                    SELECT p.ID
                    FROM $wpdb->posts p
                    INNER JOIN $wpdb->postmeta pm ON p.ID = pm.post_id
                    WHERE pm.meta_key = 'codigoProduto'
                    AND pm.meta_value = %s
                    AND p.post_status IN ('publish', 'draft')
                    LIMIT 1
                ", $primeiroCodigo));

                $imagemProduto = $post_id ? get_field('imagem_externa', $post_id) : null;
                $imgTag = $imagemProduto ? '<img src="' . esc_url($imagemProduto) . '" alt="' . htmlspecialchars($primeiroProduto['observacao']) . '" class="img-produto">' : '';

                $produtosHtml .= '
                    <div class="produto d-flex justify-content-start align-items-start mb-2">
                        <div class="me-2" style="flex-shrink:0; width: 60px;">' . $imgTag . '</div>
                        <div>
                            <div><strong>' . htmlspecialchars($primeiroProduto['observacao']) . '</strong></div>
                            <div>Qtd: ' . intval($primeiroProduto['quantidade']) . '</div>
                            <div>Subtotal: R$ ' . number_format($primeiroProduto['valorTotal'], 2, ',', '.') . '</div>';

                if ($quantidadeExtras > 0) {
                    $produtosHtml .= '
                        <div class="mt-2">
                            <button class="btn-itens-sacola" data-id="' . $row['id'] . '" onclick="'. $ligarModal .';">+ ' . $quantidadeExtras . ' outros produtos' . ($quantidadeExtras > 1 ? 's' : '') . '</button>
                        </div>';
                }

                $produtosHtml .= '</div></div>';
            }

            // Bloco do pedido
            $html .= '
            <div class="item-sacola-bloco">
                <div class="cabecalho">
                    <div class="text-muted d-flex justify-content-between">
                        <h5>Pedido #' . htmlspecialchars($row['numeroPedido']) . '</h5>
                        <div>
                            <strong class="' . $statusClass . '  status-piscando">
                                <i class="fa-solid fa-circle"></i> ' . $statusLabel . '
                            </strong>
                        </div>
                    </div>

                    <small class="text-muted"><strong>' . $dataFormatada . '</strong></small>
                </div>
                <div class="conteudo-produtos">
                    ' . $produtosHtml . '
                </div>
                <div class="rodape-pedido">
                    <div class="text-muted d-flex justify-content-between">
                        <div><em>Observação:</em> ' . htmlspecialchars($row['observacao']) . $icon . '</div>
                        <div class="text-muted tempo-previsto"><strong>Tempo previsto:</strong> '. $tempoPrevisto .' minutos</div>
                    </div>
                    <div class="text-muted"><strong>Loja:</strong> ' . htmlspecialchars($row['cnpj']) . '</div>
                    <div class="text-muted d-flex justify-content-between">
                        <div><strong>Total:</strong> R$ ' . number_format($row['valorTotal'], 2, ',', '.') . '</div>
                    </div>
                </div>
                <hr>
                <div class="rodape-pedido d-flex justify-content-center">
                    <button class="text-muted btn-ver-mais" data-id="' . $row['id'] . '" onclick="'. $ligarModal .';">Ver detalhes</button>
                </div>
            </div>';
        }

        echo json_encode([
            'success' => true,
            'html' => $html
        ]);
    } else {
        echo json_encode([
            'success' => true,
            'html' => '<p class="text-muted">Sua sacola está vazia.</p>'
        ]);
    }
}

elseif ($action == 'get_revisao') {
    $id = intval($data['id']);

    $sql = "SELECT * FROM ecommerce_pedidos WHERE id = $id LIMIT 1";
    $result = $database_connection->query($sql);

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();

        $produtos = json_decode($row['produtos'], true);
        $endereco = json_decode($row['local_entrega'], true);
        $tipo = $row['meio_de_entrega'];
        
        // Pegando latitude e longitude do endereço
        $latitude = isset($endereco['latitude']) ? floatval($endereco['latitude']) : null;
        $longitude = isset($endereco['longitude']) ? floatval($endereco['longitude']) : null;
        $frete = isset($endereco['frete']) ? floatval($endereco['frete']) : 0;

        $meioPagamento = $row['meio_de_pagamento'];

        if($meioPagamento == 1) {
            $meioPagamentoHtml = '<i class="fa-solid fa-money-bill"></i> Dinheiro';
        }
        elseif($meioPagamento == 2) {
            $meioPagamentoHtml = '<i class="fa-brands fa-pix"></i> Pix';
        }
        elseif($meioPagamento == 3) {
            $meioPagamentoHtml = '<i class="fa-solid fa-credit-card"></i> Cartão de Crédito/Debito';
        }


        $localEntrega = json_decode($row['local_entrega'], true);

        // Monta endereço completo
        $local = [];
        if (!empty($localEntrega['rua'])) $local[] = $localEntrega['rua'];
        if (!empty($localEntrega['numero'])) $local[] = $localEntrega['numero'];
        if (!empty($localEntrega['bairro'])) $local[] = $localEntrega['bairro'];
        if (!empty($localEntrega['cidade'])) $local[] = $localEntrega['cidade'];
        if (!empty($localEntrega['estado'])) $local[] = $localEntrega['estado'];
        if (!empty($localEntrega['cep'])) $local[] = $localEntrega['cep'];
        if (!empty($localEntrega['complemento'])) $local[] = "Observação: {$localEntrega['complemento']}";
        $localizacao = implode(', ', $local);

        
        $totalComDesconto = 0;
        $totalSemDesconto = 0;

        if (is_array($produtos)) {
            foreach ($produtos as $k => $p) {
                if (!empty($p['codigoProduto'])) {
                    $codigo = $p['codigoProduto'];

                    $post_id = $wpdb->get_var($wpdb->prepare("
                        SELECT p.ID
                        FROM $wpdb->posts p
                        INNER JOIN $wpdb->postmeta pm ON p.ID = pm.post_id
                        WHERE pm.meta_key = 'codigoProduto'
                        AND pm.meta_value = %s
                        AND p.post_status IN ('publish', 'draft')
                        LIMIT 1
                    ", $codigo));

                    $imagem = $post_id ? get_field('imagem_externa', $post_id) : null;

                    $precoComDesconto = isset($p['valorTotal']) ? floatval($p['valorTotal']) : 0;
                    $valorDesconto = isset($p['valorDesconto']) ? floatval($p['valorDesconto']) : 0;
                    $quantidade = isset($p['quantidade']) ? intval($p['quantidade']) : 0;

                    $precoNormalUnitario = $quantidade > 0 ? ($precoComDesconto + $valorDesconto) / $quantidade : 0;
                    $precoNormalTotal = $precoNormalUnitario * $quantidade;

                    $totalComDesconto += $precoComDesconto;
                    $totalSemDesconto += $precoNormalTotal;

                    $produtos[$k]['imagem'] = $imagem ?: '';
                }
            }
        }

        if($tipo == 1) {
            $labelMeioDeEntrega = 'Pronto para Buscar';
        } else {
            $labelMeioDeEntrega = 'Saiu para Entrega';
        }

        $valorTotal = $row['valorTotal'] ?? 0;

        $economia = $totalSemDesconto - $totalComDesconto;

        switch (intval($row['status'])) {
            case 0:
                $statusLabel = 'Pendente';
                break;
            case 1:
                $statusLabel = 'Em Andamento';
                break;
            case 2:
                $statusLabel = $labelMeioDeEntrega;
                break;
            case 3:
                $statusLabel = 'Finalizado';
                break;
            case 4:
                $statusLabel = 'Cancelado';
                break;
            default:
                $statusLabel = 'Analise';
                break;
        }

        echo json_encode([
            'success' => true,
            'status' => $statusLabel,
            'loja' => $row['cnpj'] ?? '',
            'valorTotal' => $valorTotal,
            'economia' => $economia,
            'observacao' => $row['observacao'] ?? '',
            'numeroPedido' => $row['numeroPedido'] ?? '',
            'produtos' => $produtos,
            'tempoPrevisto' => $tempoPrevisto,
            'endereco' => $endereco,
            'lat' => $latitude,
            'lng' => $longitude,
            'tipo' => $tipo,
            'frete' => $frete,
            'localizacao' => $localizacao,
            'meioPagamento' => $meioPagamentoHtml
        ]);
    } else {
        echo json_encode(['success' => false]);
    }
}

elseif ($action == 'verificarLojaHorario') {
    date_default_timezone_set('America/Sao_Paulo');

    if($ativo == 2) {
        echo json_encode(['success' => true, 'status' => 2]);
        exit;
    }

    else if($ativo == 0){
        echo json_encode(['success' => true, 'status' => 0]);
        exit;
    } 

    
    $diaDaSemana = strtolower(date('l')); // exemplo: monday, tuesday
    $diaTraduzido = [
        'monday'    => 'segunda',
        'tuesday'   => 'terca',
        'wednesday' => 'quarta',
        'thursday'  => 'quinta',
        'friday'    => 'sexta',
        'saturday'  => 'sabado',
        'sunday'    => 'domingo'
    ];

    $hoje = $diaTraduzido[$diaDaSemana];
    $agora = date('H:i');

    $novoAtivo = 3; 
    $horarioHoje = $horarioDeFuncionamento[$hoje] ?? null;

    if ($horarioHoje && !$horarioHoje['fechado']) {
        $inicio = $horarioHoje['inicio'];
        $fim = $horarioHoje['fim'];

        if ($inicio && $fim && $agora >= $inicio && $agora <= $fim) {
            $novoAtivo = 1; // está dentro do horário
        }
    }

    // Só atualiza se mudou
    if (intval($row['ativo']) !== $novoAtivo) {
        $database_connection->query("UPDATE ecommerce_config SET ativo = $novoAtivo");
    }

    echo json_encode(['success' => true, 'status' => $novoAtivo]);
    exit;
}

elseif ($action == 'calcular_frete') {
    $cep = preg_replace('/[^0-9]/', '', $data['cep'] ?? '');
    $cep = str_pad($cep, 8, '0', STR_PAD_LEFT);

    $cidadeade = $data['cidade'] ?? '';
    $bairro = $data['bairro'] ?? '';
    $rua = $data['rua'] ?? '';
    $numero = $data['numero'] ?? '';
    $latitude = isset($data['latitude']) ? (float)$data['latitude'] : null;
    $longitude = isset($data['longitude']) ? (float)$data['longitude'] : null;

    if (!$latitude || !$longitude) {
        echo json_encode([
            'success' => false,
            'message' => 'Coordenadas inválidas para o endereço informado.'
        ]);
        exit;
    }

    // Pegar coordenadas da loja selecionada
    $lojaSlug = $_POST['loja'] ?? $data['loja'] ?? '';
    if (!$lojaSlug) {
        echo json_encode(['success' => false, 'message' => 'Loja não informada.']);
        exit;
    }

    $term = get_term_by('slug', $lojaSlug, 'loja');
    if (!$term || is_wp_error($term)) {
        echo json_encode(['success' => false, 'message' => 'Loja inválida.']);
        exit;
    }

    $loja_coords = get_field('coordenadas', 'loja_' . $term->term_id);
    if (!$loja_coords) {
        echo json_encode(['success' => false, 'message' => 'Coordenadas da loja não configuradas.']);
        exit;
    }

    [$lojaLat, $lojaLng] = array_map('floatval', explode(',', $loja_coords));

    // Função de cálculo de distância (Haversine)
    function calcularDistancia($lat1, $lon1, $lat2, $lon2) {
        $R = 6371; // km
        $dLat = deg2rad($lat2 - $lat1);
        $dLon = deg2rad($lon2 - $lon1);
        $a = sin($dLat/2) * sin($dLat/2) +
             cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
             sin($dLon/2) * sin($dLon/2);
        $c = 2 * atan2(sqrt($a), sqrt(1-$a));
        return $R * $c; // distância em km
    }

    $distancia = calcularDistancia($lojaLat, $lojaLng, $latitude, $longitude);

    // Buscar zonas no banco
    $zonas = [];
    $res = $database_connection->query("SELECT id, raio, tempo, taxa, ativado AS ativo FROM ecommerce_delivery ORDER BY raio ASC");
    if ($res && $res->num_rows > 0) {
        while ($row = $res->fetch_assoc()) {
            $row['raio'] = $row['raio'] / 1000; // metros -> km
            $zonas[] = $row;
        }
    }

    // Encontra a MENOR zona cujo raio cobre a distância
    $zonaCorrespondente = null;
    foreach ($zonas as $z) {
        if ($distancia <= $z['raio']) { // raio já está em KM
            $zonaCorrespondente = $z;
            break;
        }
    }

    if (!$zonaCorrespondente) {
        echo json_encode([
            'success' => false,
            'message' => 'Endereço fora da área de entrega.'
        ]);
        exit;
    }

    // Mesmo dentro do raio, se a zona estiver desativada: bloquear
    if ((int)$zonaCorrespondente['ativo'] !== 1) {
        echo json_encode([
            'success' => false,
            'message' => 'Entrega indisponível para este endereço (zona desativada).'
        ]);
        exit;
    }

    $taxa = (float)$zonaCorrespondente['taxa'];


    echo json_encode([
        'success' => true,
        'frete' => $taxa,
        'distancia_km' => round($distancia, 2)
    ]);
    exit;
}

elseif ($action == 'checar_limite_produto') {
    $clienteUUID = $data['clienteUUID'] ?? null;
    $codigoProduto = $data['codigoProduto'] ?? null;
    $smart_id = intval($data['smart_campaign'] ?? 0);
    $quantidadeAtual = intval($data['quantidade'] ?? 0);

    if (!$clienteUUID || !$codigoProduto || !$smart_id) {
        echo json_encode(['success' => false, 'message' => 'Dados inválidos.']);
        exit;
    }

    // Busca limite do produto na campanha
    $sql_smart = "SELECT conteudo, titulo FROM smart_campaign WHERE id = ?";
    $stmt_smart = $database_connection->prepare($sql_smart);
    if (!$stmt_smart) {
        echo json_encode(['success' => false, 'message' => 'Erro ao preparar query smart_campaign: ' . $database_connection->error]);
        exit;
    }
    $stmt_smart->bind_param("i", $smart_id);
    $stmt_smart->execute();
    $res_smart = $stmt_smart->get_result();

    if ($row_smart = $res_smart->fetch_assoc()) {
        $conteudo_smart = json_decode($row_smart['conteudo'], true);
        $titulo_campanha = $row_smart['titulo'];

        // Encontra o limite do produto no JSON da campanha
        $limiteProduto = 0;
        foreach ($conteudo_smart as $item) {
            if ($item['codigo'] == $codigoProduto) {
                $nomeProduto = $item['nome'];
                $limiteProduto = intval($item['limite']);
                break;
            }
        }

        if ($limiteProduto != 999 && $limiteProduto > 0) {
            // Busca todos os pedidos do cliente
            $sql_total = "SELECT cliente, produtos FROM ecommerce_pedidos";
            $res_total = $database_connection->query($sql_total);

            $total_comprado = 0;
            while ($row_total = $res_total->fetch_assoc()) {
                $clienteData = json_decode($row_total['cliente'], true);
                $produtosAntigos = json_decode($row_total['produtos'], true);

                if (isset($clienteData['clienteUUID']) && $clienteData['clienteUUID'] == $clienteUUID) {
                    foreach ($produtosAntigos as $p) {
                        $smart_prod = intval($p['smart_campaign'] ?? 0);
                        if ($p['codigoProduto'] == $codigoProduto && $smart_prod == $smart_id) {
                            $total_comprado += intval($p['quantidade']);
                        }
                    }
                }
            }

            $restante = max(0, $limiteProduto - $total_comprado);

            if (($total_comprado + $quantidadeAtual) > $limiteProduto) {
                echo json_encode([
                    'success' => false,
                    'message' => "O limite para o produto $nomeProduto na oferta '$titulo_campanha' já foi atingido.",
                    'total_comprado' => $total_comprado,
                    'limite' => $limiteProduto,
                    'restante' => $restante
                ]);
                exit;
            } else {
                echo json_encode([
                    'success' => true,
                    'message' => "Você já comprou $total_comprado unidades deste produto. Ainda pode comprar $restante unidades.",
                    'total_comprado' => $total_comprado,
                    'limite' => $limiteProduto,
                    'restante' => $restante
                ]);
                exit;
            }
        }
    }

    // Se não há limite configurado, apenas retorna sucesso
    echo json_encode(['success' => true, 'message' => 'Produto liberado sem limite.']);
    exit;
}

elseif ($action === 'listar_enderecos') {
    $id = $data['id'] ?? null;
    if (!$id) { echo json_encode(['success'=>false,'message'=>'ID do cliente ausente.']); exit; }

    // Busca todos os pedidos DELIVERY do cliente (clienteUUID vem de JSON)
    $sql = "SELECT id, local_entrega, DATE_FORMAT(data, '%Y-%m-%d %H:%i:%s') AS data_str
    FROM ecommerce_pedidos
    WHERE JSON_UNQUOTE(JSON_EXTRACT(cliente, '$.clienteUUID')) = ?
    AND meio_de_entrega = 2
    AND local_entrega IS NOT NULL
    AND local_entrega <> ''
    ORDER BY data DESC";

    $stmt = $database_connection->prepare($sql);
    if (!$stmt) { echo json_encode(['success'=>false,'message'=>'Falha na query.']); exit; }
    $stmt->bind_param("s", $id);
    $stmt->execute();
    $res = $stmt->get_result();

    // normalização para dedupe
    $normalize = function($s){
        $s = trim((string)$s);
        $s = mb_strtoupper($s, 'UTF-8');
        $s = iconv('UTF-8','ASCII//TRANSLIT//IGNORE', $s);
        return preg_replace('/\s+/', ' ', $s);
    };

    $vistos = [];
    $cards  = '';
    $valor = 3;
    $marcouRecente = false;

    while ($row = $res->fetch_assoc()) {
        $e = json_decode($row['local_entrega'], true);
        if (json_last_error() !== JSON_ERROR_NONE || !is_array($e)) continue;

        $cep  = $e['cep'] ?? '';
        $cidade  = $e['cidade'] ?? '';
        $uf   = $e['estado'] ?? '';
        $bairro = $e['bairro'] ?? '';
        $rua  = $e['rua'] ?? '';
        $num  = $e['numero'] ?? '';
        $comp = $e['complemento'] ?? '';
        $lat  = $e['latitude'] ?? '';
        $lng  = $e['longitude'] ?? '';

        // chave para remover duplicados (mesmo endereço)
        $key = implode('|', [
            $normalize($cep), $normalize($cidade), $normalize($uf),
            $normalize($bairro), $normalize($rua), $normalize($num)
        ]);
        if (isset($vistos[$key])) continue;
        $vistos[$key] = true;

        $checkedAttr = '';
        if (!$marcouRecente) {
            $checkedAttr = ' checked';
            $marcouRecente = true;
        }


        $linha1 = trim($rua . ($num ? ", $num" : ""));
        $linha2 = trim($linha1 . " - " . ($bairro ? "$bairro, " : "") . ($cidade ?: "") . ($uf ? " - $uf" : ""));
        $resumo = trim($linha2 . ($cep ? ", $cep" : ""));

        // um card por endereço; value = id do pedido
        $cards .= '
        <div class="lista-pagamentos">
        <label class="opcao-pagamento">
            <input type="radio" name="opcao-endereco" value="'.$valor.'"
                data-cep="'.htmlspecialchars($cep,ENT_QUOTES).'"
                data-cidade="'.htmlspecialchars($cidade,ENT_QUOTES).'"
                data-estado="'.htmlspecialchars($uf,ENT_QUOTES).'"
                data-bairro="'.htmlspecialchars($bairro,ENT_QUOTES).'"
                data-rua="'.htmlspecialchars($rua,ENT_QUOTES).'"
                data-numero="'.htmlspecialchars($num,ENT_QUOTES).'"
                data-complemento="'.htmlspecialchars((string)$comp,ENT_QUOTES).'"
                data-lat="'.htmlspecialchars((string)$lat,ENT_QUOTES).'"
                data-lng="'.htmlspecialchars((string)$lng,ENT_QUOTES).'"
                data-data="'.htmlspecialchars($row['data_str'] ?? '',ENT_QUOTES).'"'.$checkedAttr.'>
            <span><i class="fa-solid fa-location-dot"></i> '.htmlspecialchars($linha1).'</span>
            <small>'.htmlspecialchars($resumo).'</small>
        </label>
        </div>';


        $valor++;
    }

    echo json_encode(['success'=>true,'data'=>$cards], JSON_UNESCAPED_UNICODE);
    exit;
}

function montar_cliente_erp(array $clienteArr, array $enderecoArr = []): array {
    $cliente = [
        'nome'        => (string)($clienteArr['nome'] ?? ''),
        // CPF **com pontuação** como você pediu
        'cnpjCpf'     => (string)($clienteArr['cnpjCpf'] ?? $clienteArr['cpf'] ?? ''),
        // telefone vai sem máscara (ERP costuma aceitar ambos; deixe assim se já funcionou)
        'telefone'    => preg_replace('/\D+/', '', ($clienteArr['telefone'] ?? $clienteArr['celular'] ?? '')),

        // Endereço do cliente (o ERP devolve esses nomes)
        'endereco'    => (string)($enderecoArr['rua'] ?? $clienteArr['rua'] ?? ''),
        'numero'      => (int)   ($enderecoArr['numero'] ?? $clienteArr['numero'] ?? 0),
        'complemento' => (string)($enderecoArr['complemento'] ?? $clienteArr['complemento'] ?? ''),
        'bairro'      => (string)($enderecoArr['bairro'] ?? $clienteArr['bairro'] ?? ''),
        'municipio'   => (string)($enderecoArr['cidade'] ?? $clienteArr['cidade'] ?? ''),
        'uf'          => (string)($enderecoArr['estado'] ?? $clienteArr['estado'] ?? ''),
        'cep'         => (string)($enderecoArr['cep'] ?? $clienteArr['cep'] ?? ''),

        // Extras que o ERP demonstra conhecer
        'email'       => (string)($clienteArr['email'] ?? ''),
        'sexo'        => (string)($clienteArr['genero'] ?? $clienteArr['sexo'] ?? ''),

        // Campos opcionais (preenche se tiver; o ERP aceita nulos)
        'razaoSocial'           => (string)($clienteArr['razaoSocial'] ?? ''),
        'inscricaoEstadual'     => (string)($clienteArr['inscricaoEstadual'] ?? ''),
        'autorizacao'           => (string)($clienteArr['autorizacao'] ?? ''), // "S" / "N" se você usar
        'tipo'                  => (string)($clienteArr['tipo'] ?? ''),        // "C" etc.
        'codClasse'             => (string)($clienteArr['codClasse'] ?? ''),
        'codSituacao'           => (string)($clienteArr['codSituacao'] ?? ''),
        'codQualificacao'       => (string)($clienteArr['codQualificacao'] ?? ''),
        'clubeDesconto'         => (string)($clienteArr['clubeDesconto'] ?? ''),
        'codPrecoClubeDesconto' => (int)   ($clienteArr['codPrecoClubeDesconto'] ?? 0),
    ];

    // remove chaves vazias/nulas para não sujar o payload
    return array_filter($cliente, static function($v) {
        return !($v === '' || $v === null);
    });
}


exit;
