<?php  

require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';

// $produtos_destaque = get_field('produtos_destaque', 'options');

$page       = isset($_GET['page']) ? $_GET['page'] : 1;
$id_familia = isset($_GET['id_familia']) ? intval($_GET['id_familia']) : null;

// Definindo um valor padrão para evitar warnings
$posts_per_page = -1;

// ⚙️ Regras de e-commerce
$ecommerce_ativado = get_data('ecommerce_config', 'ativo') ?? 0;                    // prioridade
$ecommerce_ligado  = get_data('ecommerce_config', 'produtos_ecommerce_ativo') ?? 0; // filtra produtos e/ou botão

$produtoReview = get_data('admin_config', 'product_review') ?? 0;


// Verifica se infinite_scroll está definido e se é exatamente 'false' (como string)
if (isset($_GET['infinite_scroll']) && $_GET['infinite_scroll'] === 'false') {
    $posts_per_page = -1;
}

$argsOfertas = array(
    'post_type'      => 'oferta',
    'orderby'        => 'title',
    'post_status'    => 'publish',
    'order'          => 'ASC',
    'posts_per_page' => $posts_per_page,
    'paged'          => $page,
);

$ofertas = new WP_Query($argsOfertas);
$html = '';
$ofertas_por_familia = array();
$ofertas_sem_familia = array();
$count_sem_familia = 0;
$numberId = 0;

if ($ofertas->have_posts()):
    while ($ofertas->have_posts()) : $ofertas->the_post();

        // 🔍 Se o modo de revisão estiver ativo, só mostra produtos revisados
        if ($produtoReview) {
            $rev = get_field('revisao'); // campo ACF Verdadeiro/Falso
            if (!($rev === 1 || $rev === '1' || $rev === true)) {
                continue; // pula este produto
            }
        }

        $familia_id = get_field('familia');

        if ($id_familia) {
            // Se está filtrando por uma família específica
            if (intval($familia_id) !== $id_familia) {
                continue; // Pula o post se não for da família desejada
            }

            if (!isset($ofertas_por_familia[$familia_id])) {
                $ofertas_por_familia[$familia_id] = [];
            }

            $ofertas_por_familia[$familia_id][] = $post;

        } else {
            // Fluxo original (sem filtro)
            if ($familia_id) {
                if (!isset($ofertas_por_familia[$familia_id])) {
                    $ofertas_por_familia[$familia_id] = [];
                }

                $ofertas_por_familia[$familia_id][] = $post;

            } else {
                $count_id = get_the_ID();
                if (!isset($ofertas_sem_familia[$count_id])) {
                    $ofertas_sem_familia[$count_id] = [];
                }

                $ofertas_sem_familia[$count_id][] = $post;
                $count_sem_familia++;
            }
        }

    endwhile;

    for ($i = 0; $i < 2; $i++) {
        if ($i == 0) {
            $loop = $ofertas_por_familia;
        } else {
            $loop = $ofertas_sem_familia;
        }

        // Agora, processe cada família de ofertas
        foreach ($loop as $familia_id => $ofertas_da_familia) {

            // Resetar as variáveis para cada família
            $etiqueta = '';
            $precos_html = '';
            $imagem = '';
            $descricao = '';
            $cashback = 'false';
            $economia = 0;
            $valorCashback = 0;
            $unidadeMedida = '';

            // Assuma que a primeira oferta da família representa as informações básicas
            $primeira_oferta = $ofertas_da_familia[0];

            // Defina as variáveis com base na primeira oferta
            if (empty($primeira_oferta)) {
                $idOfertaThis = $familia_id;
                setup_postdata($familia_id);
            } else {
                $idOfertaThis = $primeira_oferta->ID;
                setup_postdata($primeira_oferta);
            }

            $order = "9999"; // Define uma ordem padrão caso o produto não esteja em destaque
            $select_order = "";

            if (get_the_post_thumbnail_url($idOfertaThis)) {
                $imagem = get_field('imagem_externa', $idOfertaThis);
            } else {
                $imagem = get_field('imagem_externa', $idOfertaThis);
            }

            $familia_raw = get_field('familia', $idOfertaThis);

            $valorProduto        = get_field('valor', $idOfertaThis);
            $valorProdutoOferta  = get_field('valor_promocional', $idOfertaThis);
            $descricao           = get_field('descricao', $idOfertaThis);
            $unidadeMedida       = get_field('unidade_de_medida', $idOfertaThis);

            $raw_value     = get_field('aplicativo', $idOfertaThis);
            $exibir_no_app = $raw_value === null ? true : $raw_value;
            $exibir_no_app = $exibir_no_app === true ? 'true' : 'false';

            if ($unidadeMedida != '') { $unidadeMedida = '(' . $unidadeMedida . ')'; }
            $economia = $valorProduto - $valorProdutoOferta;
            $cashback = 'false';

            $produtosComCashback = get_field('produtos_especificos_cashback', 'options');

            // ⚙️ Flag ecommerce do post
            $ecommerce_raw = get_field('ecommerce', $idOfertaThis);
            $in_ecommerce  = ($ecommerce_raw === 1 || $ecommerce_raw === '1' || $ecommerce_raw === true);

            // 🔎 Se o modo "produtos_ecommerce_ativo" estiver ligado, mostramos APENAS produtos e-commerce
            // if ($ecommerce_ligado && !$in_ecommerce) {
            //     wp_reset_postdata();
            //     continue;
            // }

            // 🎛️ Classe/estilo do botão de carrinho conforme regras:
            // - se ecommerce geral (ativo) estiver 0 -> sempre esconde
            // - se ativo=1 e produtos_ecommerce_ativo=1 -> mostra só se o produto for e-commerce
            // - se ativo=1 e produtos_ecommerce_ativo=0 -> mostra para todos
            if (!$ecommerce_ativado) {
                $ecommerce_class = 'style="display:none;"';
            } elseif ($ecommerce_ligado) {
                $ecommerce_class = $in_ecommerce ? '' : 'style="display:none;"';
            } else {
                $ecommerce_class = '';
            }

            if ($produtosComCashback) {
                foreach ($produtosComCashback as $key => $produto) {
                    if ($produto['produto']->ID === get_the_ID()) {
                        $valorCashback = $produto['valor'];
                        $cashback = 'true';
                    }
                }
            }

            if (get_field('no_clube', $idOfertaThis) == 1 && get_field('fora_do_clube', $idOfertaThis) == 1 || get_field('no_clube', $idOfertaThis) == 1 && get_field('fora_do_clube', $idOfertaThis) == 0) {
                $etiqueta = "<div class='etiqueta clube'>Clube</div>";
            } elseif (get_field('fora_do_clube', $idOfertaThis) == 1) {
                $etiqueta = "<div class='etiqueta oferta'>Oferta</div>";
            }

            // Obtém o valor do ACF "precos" para o post atual
            $precos_json = get_field('precos', $idOfertaThis);

            // Converte o valor obtido em formato JSON para um array associativo do PHP
            $precos = json_decode($precos_json, true);
            if (!$precos) {
                wp_reset_postdata();
                continue;
            }

            // Inicializa um array para armazenar os preços por loja
            $precos_por_loja = array();

            // Agrupa os preços por loja
            foreach ($precos as $preco) {
                $lojas = explode(';', $preco['loja']);
                foreach ($lojas as $loja) {
                    if (!isset($precos_por_loja[$loja])) {
                        $precos_por_loja[$loja] = array(
                            'valor'  => $preco['valor'],
                            'oferta' => $preco['oferta'],
                        );
                    } else {
                        if ($precos_por_loja[$loja]['valor'] == $preco['valor'] && $precos_por_loja[$loja]['oferta'] == $preco['oferta']) {
                            continue;
                        }
                        $precos_por_loja[$loja] = array(
                            'valor'  => $preco['valor'],
                            'oferta' => $preco['oferta'],
                        );
                    }
                }
            }

            // Inicializa um array para armazenar os preços únicos
            $precos_unicos = array();

            // Agrupa os preços por valor e oferta
            foreach ($precos_por_loja as $loja => $preco) {

                $numberId++;

                $valor  = $preco['valor'];
                $oferta = $preco['oferta'];

                $precos_html .= '<div class="precoOferta">';
                $precos_html .= '<del>R$ ' . number_format($valor, 2, ',', '.') . '</del>';
                $precos_html .= '<span>R$ ' . number_format($oferta, 2, ',', '.') . '</span>';
                $precos_html .= '</div>';

                $checkBox = "<div class='form-check'> 
                        <input class='form-check-input checkbox-produto' type='checkbox' id='product-$idOfertaThis'>
                    </div>";

                // Construa o bloco
                $bloco = '
                    <div class="col-lg-4 col-md-6 col-sm-6 col-xs-6" data-familia="' . $familia_raw . '" data-id="' . $idOfertaThis . '" data-oferta="' . $idOfertaThis . '" data-exibir-app=' . $exibir_no_app . ' data-loja="loja-' . ltrim($loja, '0') . '" style="order: ' . $order . '">
                        <div class="blocoOfertaApp ' . $select_order . '" data-familia="' . $familia_raw . '" data-id="' . $idOfertaThis . '" data-oferta="' . $idOfertaThis . '" data-exibir-app=' . $exibir_no_app . ' data-ecommerce=' . ($in_ecommerce ? '1' : '0') . '>
                        <p class="economia">Economize R$ ' . number_format($economia, '2', ',', '.') . '</p>';

                $displayAdmin = current_user_can('administrator');

                if ($displayAdmin) {
                    $bloco .= $checkBox;
                }

                $bloco .= '
                        <div class="imagemOferta editable-imagem">
                            <img src="' . $imagem . '" alt="' . get_the_title($idOfertaThis) . '">
                        </div>
                        <span class="aviso">*Imagem meramente ilustrativa</span>
                        <p class="nomeOferta">' . get_the_title($idOfertaThis) . '<span>' . $unidadeMedida . '</span></p>
                        ' . $etiqueta . '
                        ' . $precos_html . '
                ';

                if (!empty($ofertas_da_familia) && count($ofertas_da_familia) > 1 && !$id_familia) {

                    $opcoes = array();
                    foreach ($ofertas_da_familia as $ofertaSub) {
                        setup_postdata($ofertaSub);

                        $precos_jsonSub = get_field('precos', $ofertaSub->ID);
                        $precosSub = json_decode($precos_jsonSub, true);
                        if (!$precosSub) continue;

                        $precos_por_lojaSub = array();

                        foreach ($precosSub as $precoSub) {
                            $lojasSub = explode(';', $precoSub['loja']);

                            foreach ($lojasSub as $lojaSub) {

                                if ($lojaSub == $loja) {
                                    if (!isset($precos_por_lojaSub[$lojaSub])) {
                                        $precos_por_lojaSub[$lojaSub] = array(
                                            'valor'  => $precoSub['valor'],
                                            'oferta' => $precoSub['oferta'],
                                        );
                                    } else {
                                        if ($precos_por_lojaSub[$lojaSub]['valor'] == $precoSub['valor'] && $precos_por_lojaSub[$lojaSub]['oferta'] == $precoSub['oferta']) {
                                            continue;
                                        }
                                        $precos_por_lojaSub[$lojaSub] = array(
                                            'valor'  => $precoSub['valor'],
                                            'oferta' => $precoSub['oferta'],
                                        );
                                    }
                                }

                            }
                        }
                        foreach ($precos_por_lojaSub as $lojaInt => $precoSub) {
                            $valorInt  = $precoSub['valor'];
                            $ofertaInt = $precoSub['oferta'];
                            $opcoes[] = array(
                                'titulo' => get_the_title($ofertaSub->ID),
                                'valor'  => "<del>R$ $valorInt</del>",
                                'oferta' => "<span>R$ $ofertaInt</span>",
                                'loja'   => $lojaInt
                            );
                        }
                    }

                    // (botão de ver opções, se quiser reativar)
                    // $bloco .= '<button class="ver-opcoes" data-opcoes=\''.json_encode($opcoes).'\'"><i class="fa-solid fa-search-plus"></i> Ver opções</button>';
                }

                if (get_field('aplicar_cashback', 'options') == 'sim' && get_field('aplicacao_do_cashback', 'options') == 'produto_especifico' && $cashback == 'true') {
                    $cashback = number_format($valorCashback, '2', ',', '.');
                    $bloco .= '<p class="cashback"> Cashback de R$ ' . $cashback . '</p>';
                } elseif (get_field('aplicar_cashback', 'options') == 'sim' && (get_field('aplicacao_do_cashback', 'options') == 'valor_total' || get_field('aplicacao_do_cashback', 'options') == 'valor_clube')) {
                    if (get_field('tipo_do_cashback', 'options') == 'percentual') {
                        $valor    = get_field('valor_cashback', 'options');
                        $cashback = $oferta * ($valor / 100);
                        $cashback = number_format($cashback, '2', ',', '.');
                        $bloco .= '<p class="cashback">Cashback de R$ ' . $cashback . ' (' . $valor . '%)</p>';
                    }
                }
                $bloco .= '<p class="descricaoOferta">' . $descricao . '</p>';

                if (!empty($ofertas_da_familia) && count($ofertas_da_familia) > 1 && !$id_familia) {
                    $botaoCarrinho = '<div class="section-family">
                            <button class="btn-familia see-family" data-id="geral" data-familia="' . $familia_id . '"><i class="fa-solid fa-eye"></i> Ver Opções</button>
                        </div>
                        ';
                } else {
                    $botaoCarrinho = '<div class="adicionar-carrinho" ' . $ecommerce_class . '>
                            <div class="quantidade">
                                <button class="btn-menos">-</button>
                                <input type="number" min="1" value="1" class="input-quantidade" />
                                <button class="btn-mais">+</button>
                            </div>
                                <button class="btn-adicionar add-cart" data-id="' . $idOfertaThis . '"><i class="fa-solid fa-cart-shopping"></i>Comprar</button>
                            </div>
                        ';
                }

                $bloco .= $botaoCarrinho;

                $bloco .= '
                        </div>
                    </div>
                ';

                // Imprima o bloco
                $html .= $bloco;
                $precos_html = '';

            }

            // Resete as configurações do postdata após processar cada oferta
            wp_reset_postdata();
        }

    }

    echo $html;

else:
    if ($page == 1) {
        echo 0;
    } else {
        echo 1;
    }
endif;

?>
