<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';

global $wpdb;

// Pega o id do usuário enviado por POST
$usuario_id  = isset($_POST['usuario_id']) ? sanitize_text_field($_POST['usuario_id']) : null; // pode ser UUID
$slug_loja   = isset($_POST['loja_slug'])  ? sanitize_text_field($_POST['loja_slug'])  : null;
$cnpj_post   = isset($_POST['cnpj'])       ? preg_replace('/\D+/', '', $_POST['cnpj']) : null;
$coordenada_usuario = null;

if (isset($_POST['action']) && $_POST['action'] === 'get_cnpj') {
    $slug_loja = isset($_POST['loja_slug']) ? sanitize_text_field($_POST['loja_slug']) : '';
    if (!$slug_loja) {
        echo json_encode(['success' => false, 'message' => 'slug ausente']);
        exit;
    }

    $term = get_term_by('slug', $slug_loja, 'loja');
    if (!$term || is_wp_error($term)) {
        echo json_encode(['success' => false, 'message' => 'loja não encontrada']);
        exit;
    }

    $cnpj = get_field('cnpj', 'loja_' . $term->term_id);
    echo json_encode(['success' => true, 'cnpj' => $cnpj ?: '']);
    exit;
}

// Se tiver ID, busca a coordenada do cliente no banco
if ($usuario_id) {
    $coordenada_usuario = $wpdb->get_var($wpdb->prepare("SELECT coordenadas FROM customers WHERE cliente_uuid = %d", $usuario_id));
    // echo $coordenada_usuario;
}

$terms = [];
if ($cnpj_post) {
    // Quando vier CNPJ, busca a loja pela meta 'cnpj'
    $terms = get_terms([
        'taxonomy'   => 'loja',
        'hide_empty' => false,
        'meta_query' => [[
            'key'     => 'cnpj',
            'value'   => $cnpj_post,
            'compare' => '='
        ]],
        'number'     => 1, // só precisa de uma loja
    ]);
} else {
    // Fluxo existente por slug (ou lista todas)
    $terms = get_terms([
        'taxonomy'   => 'loja',
        'hide_empty' => false,
        'orderby'    => 'name',
        'order'      => 'ASC'
    ]);

    if ($slug_loja) {
        $terms = array_filter($terms, function($term) use ($slug_loja) {
            return $term->slug === $slug_loja;
        });
    }
}



$html = '';
$number = 1;

if (!empty($terms) && !is_wp_error($terms)) {
    foreach ($terms as $term) {
        $nome = htmlspecialchars($term->name);
        $slug = htmlspecialchars($term->slug);
        $cnpj = get_field('cnpj', 'loja_' . $term->term_id);
        $cep = get_field('cep', 'loja_' . $term->term_id);
        $numero = get_field('numero', 'loja_' . $term->term_id);
        $bairro = get_field('bairro', 'loja_' . $term->term_id);
        $cidade = get_field('cidade', 'loja_' . $term->term_id);
        $estado = get_field('estado', 'loja_' . $term->term_id);
        $coordenadas = get_field('coordenadas', 'loja_' . $term->term_id);

        $distancia_km = '';

        if (!empty($coordenadas) && !empty($coordenada_usuario) && strpos($coordenadas, ',') !== false && strpos($coordenada_usuario, ',') !== false) {
            list($lat_loja, $lng_loja) = array_map('trim', explode(',', $coordenadas));
            list($lat_usuario, $lng_usuario) = array_map('trim', explode(',', $coordenada_usuario));

            if (is_numeric($lat_loja) && is_numeric($lng_loja) && is_numeric($lat_usuario) && is_numeric($lng_usuario)) {
                $distancia_km = calcular_distancia($lat_usuario, $lng_usuario, $lat_loja, $lng_loja);
            }
        }

        $endereco = "$bairro, $numero - $cidade/$estado, $cep";

        $html .= "
        <div class='bloco-loja' data-loja='$slug' style='cursor:pointer; border: 1px solid #ccc; padding: 10px; border-radius: 8px; background: #f9f9f9; transition: 0.3s;'>";
        
        if($cnpj_post) {
            $number = 'para Retirada';
        }

        // if(!$slug_loja) {
        //     $html .= "<h4 style='margin-bottom: 5px; font-weight: 600;'>Loja $number</h4>";
        // }
        $html .= "<p style='margin: 0; font-size: 12px;'>$endereco</p>";

        if ($distancia_km !== '') {
            $html .= "<p style='margin: 5px 0; font-weight:bold; color:#555;'>📍 Aproximadamente {$distancia_km} km</p>";
        }

        $html .= "<div class='mapa-loja' style='margin-top: 10px;'>";

        if (!empty($coordenadas) && strpos($coordenadas, ',') !== false) {
            list($lat, $lng) = array_map('trim', explode(',', $coordenadas));
            $html .= "
                <iframe width='100%' height='100' style='border:0' loading='lazy'
                    src='https://maps.google.com/maps?q=$lat,$lng&hl=pt&z=16&output=embed'>
                </iframe>
            ";
        } else {
            $html .= "
                <iframe width='100%' height='100' style='border:0' loading='lazy'
                    src='https://www.google.com/maps?q=" . urlencode($endereco) . "&output=embed'>
                </iframe>
            ";
        }

        $html .= "</div></div>";
        $number++;
    }
}

echo $html;

function calcular_distancia($lat1, $lon1, $lat2, $lon2) {
    $raio_terra = 6371; // em km
    $lat1 = deg2rad($lat1);
    $lon1 = deg2rad($lon1);
    $lat2 = deg2rad($lat2);
    $lon2 = deg2rad($lon2);

    $dif_lat = $lat2 - $lat1;
    $dif_lon = $lon2 - $lon1;

    $a = sin($dif_lat/2) * sin($dif_lat/2) +
         cos($lat1) * cos($lat2) * sin($dif_lon/2) * sin($dif_lon/2);

    $c = 2 * atan2(sqrt($a), sqrt(1-$a));

    return round($raio_terra * $c, 1);
}

?>
